Games Arena — Listing the games developed for different platforms !
[Problem Statement]

Develop a pseudo front end application which would let the users help list and browse games developed for different platforms conveniently.

[Minimum Requirement]

— Use of Web API to fetch games details.

Utilise Response Parameters:

[ title, platform, score, genre, editors_choice ].
Implement functionality to list games in a web page.

— Visually interactive responsive design listing all the games.

— Submit Screenshot, Source code & Instructions.

[Plus Point]

— A feature to Search (via name).

— Implement Sort feature (to filter through ‘score’ in ascending and descending order).

[Extra Work]

— Implement feature to sort games based on platform.(List on PS games or any other platforms).

— Add autocomplete feature to Search games conveniently .

— Custom elegant design, fonts and icons to make web app more user-friendly.

— You may add portfolio activity comprising awesome work you have done on web application(s).

— Use your imagination and add features which would make things easier for end users.

[Guide]

— Games API: http://starlord.hackerearth.com/gamesarena

— Ideal Frontend Stack:

Any of your favourite JS Framework: Javascript (Angular JS), jQuery, HTML, CSS.

Custom CSS, Good if you can work around Bootstrap or Material Design.

Optional: Typography, Subtle pattern, Custom Icons.

— PS: Application can be built with use of client-side scripting and need not require any backend.

— HTML5 Local Storage: http://html5demos.com/storage

— For icons and subtle texture:

http://glyphsearch.com/

http://subtlepatterns.com/thumbnail-view/

http://codebeautify.org/jsonviewer

http://www.flaticon.com/categories

— API Specs (shall be accessible once event starts) —

Supports GET/POST/PUT requests on HTTP as well as HTTPS.

Output Response: JSON, CSV or XML

HTTP Header

access-control-allow-headers:Origin, X-Requested-With, Content-Type, Accept

access-control-allow-methods:GET, POST, PUT

access-control-allow-origin: \*

server: cloudflare-nginx

Structure / Data Parameters:

title, platform, score, genre, editors_choice

title — ‘title of the game’

platform — name of the platform for which this game is designed.

score — games rating score.

genre — genre of the game.

editors_choice — A value indicating whether this game was editor’s choice or not.
